#include <bits/stdc++.h>
using namespace std;

const int N = 4;
const int K = 5;

int n, k, m;
string category[K];
string value[K][N];

map<string, pair<int, int>> value_mapping;
map<string, int> category_mapping;

struct Rule {
  int c1, v1;
  int c2, v2;
  bool equal;
};

vector<Rule> all_rules[K];

int perm[K][N];
int answers[K][N][K][N];

bool IsRuleSatisfied(const Rule &rule) {
  bool equality = perm[rule.c1][rule.v1] == perm[rule.c2][rule.v2];
  return equality == rule.equal;
}

bool AreRulesSatisfied(const vector<Rule> &rules) {
  for (const auto &rule : rules) {
    if (!IsRuleSatisfied(rule))
      return false;
  }
  return true;
}

bool possible = false;

string Query(string el_str, string cat_str) {
  auto el = value_mapping[el_str];
  auto cat = category_mapping[cat_str];
  string ret = "";
  for (int i = 0; i < n; ++i) {
    if (!answers[el.first][el.second][cat][i])
      continue;
    if (ret != "") return "-1";
    ret = value[cat][i];
  }
  return ret;
}

void Recursion(int depth) {
  if (depth == k) {
    possible = true;
    static int perm_inv[K][N];
    for (int i = 0; i < k; ++i) {
      for (int j = 0; j < n; ++j) {
        perm_inv[i][perm[i][j]] = j;
      }
    }
    for (int i1 = 0; i1 < k; ++i1) {
      for (int i2 = 0; i2 < i1; ++i2) {
        for (int j = 0; j < n; ++j) {
          int j1 = perm_inv[i1][j];
          int j2 = perm_inv[i2][j];
          answers[i1][j1][i2][j2] = true;
          answers[i2][j2][i1][j1] = true;
        }
      }
    }
    return;
  }

  sort(perm[depth], perm[depth] + n);
  do {
    if (AreRulesSatisfied(all_rules[depth]))
      Recursion(depth + 1);
  } while (next_permutation(perm[depth], perm[depth] + n));
}

int main(void) {
  cin >> k >> n;
  for (int i = 0; i < k; ++i) {
    cin >> category[i];
    category_mapping[category[i]] = i;
    for (int j = 0; j < n; ++j) {
      cin >> value[i][j];
      value_mapping[value[i][j]] = {i, j};
    }
  }
  
  cin >> m;
  for (int i = 0; i < m; ++i) {
    string el1_str, el2_str, cmp;
    cin >> el1_str >> cmp >> el2_str;
    auto el1 = value_mapping[el1_str];
    auto el2 = value_mapping[el2_str];
    if (el1 > el2) swap(el1, el2);
    Rule r = {el1.first, el1.second, el2.first, el2.second, cmp == "je"};
    all_rules[r.c2].push_back(r);
  }
 
  for (int i = 0; i < k; ++i) {
    for (int j = 0; j < n; ++j) {
      perm[i][j] = j;
    }
  } 

  Recursion(1);

  int q;
  cin >> q;
  for (int i = 0; i < q; ++i) {
    string el, cat;
    cin >> el >> cat;
    cout << Query(el, cat) << endl;
  }

  return 0;
}
